/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.adaptivetooltips.helpers.positioner;

import dev.isxander.adaptivetooltips.config.AdaptiveTooltipConfig;
import dev.isxander.adaptivetooltips.helpers.positioner.TooltipPositionModule;
import java.util.Optional;
import java.util.TreeMap;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class BestCornerPositionModule
implements TooltipPositionModule {
    @Override
    public Optional<Vector2ic> repositionTooltip(int x, int y, int width, int height, int mouseX, int mouseY, int screenWidth, int screenHeight) {
        if (!((AdaptiveTooltipConfig)AdaptiveTooltipConfig.HANDLER.instance()).bestCorner) {
            return Optional.empty();
        }
        if (x < 4 || y < 4 || ((AdaptiveTooltipConfig)AdaptiveTooltipConfig.HANDLER.instance()).alwaysBestCorner) {
            int topObstruction = Math.max(5 + height - mouseY, 0);
            int bottomObstruction = Math.max(mouseY - (screenHeight - 5 - height), 0);
            int leftObstruction = Math.max(5 + width - mouseX, 0);
            int rightObstruction = Math.max(mouseX - (screenWidth - 5 - width), 0);
            TreeMap<Integer, Vector2i> corners = new TreeMap<Integer, Vector2i>();
            corners.put(rightObstruction * topObstruction, new Vector2i(screenWidth - 5 - width, 5));
            corners.put(leftObstruction * bottomObstruction, new Vector2i(5, screenHeight - 5 - height));
            corners.put(rightObstruction * bottomObstruction, new Vector2i(screenWidth - 5 - width, screenHeight - 5 - height));
            corners.put(topObstruction * leftObstruction, new Vector2i(5, 5));
            return Optional.of((Vector2ic)corners.firstEntry().getValue());
        }
        return Optional.empty();
    }
}

